/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.mixin;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.block.ICustomizableDrops;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.skills.MotherlodeSkill;
import dev.toma.gunsrpg.config.world.WorldConfiguration;
import dev.toma.gunsrpg.util.Lifecycle;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.util.object.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractBlock.class})
public abstract class AbstractBlockMixin
extends ForgeRegistryEntry<Block> {
    @Shadow
    public abstract ResourceLocation func_220068_i();

    @Inject(method={"getDrops"}, at={@At(value="HEAD")}, cancellable=true)
    public void gunsrpg_modifyBlockDrops(BlockState state, LootContext.Builder ctxBuilder, CallbackInfoReturnable<List<ItemStack>> ci) {
        ResourceLocation location = this.func_220068_i();
        if (location == LootTables.field_186419_a) {
            ci.setReturnValue(Collections.emptyList());
        } else {
            LootContext lootContext = ctxBuilder.func_216015_a(LootParameters.field_216287_g, (Object)state).func_216022_a(LootParameterSets.field_216267_h);
            ServerWorld serverWorld = lootContext.func_202879_g();
            LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(location);
            ci.setReturnValue(this.actuallyModify(lootContext, serverWorld, state, lootTable));
        }
    }

    private List<ItemStack> actuallyModify(LootContext context, ServerWorld world, BlockState state, LootTable table) {
        List drops = table.func_216113_a(context);
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (state == null || !(entity instanceof PlayerEntity)) {
            return drops;
        }
        Block block = state.func_177230_c();
        if (block instanceof ICustomizableDrops) {
            return ((ICustomizableDrops)block).getCustomDrops(table, context);
        }
        PlayerEntity player = (PlayerEntity)entity;
        IPlayerData data = (IPlayerData)PlayerData.get(player).orElse(null);
        if (data == null) {
            return drops;
        }
        ISkillProvider skillProvider = data.getSkillProvider();
        if (block.func_203417_a((ITag)BlockTags.field_200031_h)) {
            this.applyLogDrops(drops, block, player, world, skillProvider);
        } else if (block.func_203417_a((ITag)Tags.Blocks.ORES)) {
            this.applyOreDrops(drops, block, player, data);
        }
        return drops;
    }

    private void applyLogDrops(List<ItemStack> drops, Block block, PlayerEntity player, ServerWorld world, ISkillProvider skillProvider) {
        MinecraftServer server = world.func_73046_m();
        if (server == null || !skillProvider.hasSkill(Skills.LUMBERJACK_I)) {
            return;
        }
        List recipes = server.func_199529_aN().func_241447_a_(IRecipeType.field_222149_a);
        for (ICraftingRecipe recipe : recipes) {
            Ingredient ingredient;
            NonNullList ingredients = recipe.func_192400_c();
            if (ingredients.size() != 1 || !(ingredient = (Ingredient)ingredients.get(0)).test(new ItemStack((IItemProvider)block))) continue;
            ItemStack result = recipe.func_77571_b();
            Pair<Float, Float> chances = SkillUtil.getTopHierarchySkill(Skills.LUMBERJACK_I, skillProvider).getDropChances();
            Random random = player.func_70681_au();
            if (random.nextFloat() < chances.getLeft().floatValue()) {
                drops.add(new ItemStack((IItemProvider)result.func_77973_b(), 1));
            }
            if (!(random.nextFloat() < chances.getRight().floatValue())) break;
            drops.add(new ItemStack((IItemProvider)Items.field_151055_y, 2));
            break;
        }
    }

    private void applyOreDrops(List<ItemStack> drops, Block block, PlayerEntity player, IPlayerData data) {
        ISkillProvider provider = data.getSkillProvider();
        MotherlodeSkill skill = SkillUtil.getTopHierarchySkill(Skills.MOTHER_LODE_I, provider);
        Random random = player.func_70681_au();
        int multiplier = 1;
        if (skill != null) {
            multiplier = skill.getDropMultiplier(random, data);
        }
        Iterator<ItemStack> iterator = drops.iterator();
        ArrayList<ItemStack> extraDrops = new ArrayList<ItemStack>();
        Lifecycle lifecycle = GunsRPG.getModLifecycle();
        WorldConfiguration configuration = GunsRPG.config.world;
        while (iterator.hasNext()) {
            List<ItemStack> extras;
            ItemStack stack = iterator.next();
            Item dropReplacement = lifecycle.getOreDropReplacement(stack.func_77973_b());
            if (dropReplacement != null) {
                extras = configuration.replaceOresAsChunks ? this.multiply(new ItemStack((IItemProvider)dropReplacement, stack.func_190916_E()), multiplier) : Collections.singletonList(stack.func_77946_l());
                extraDrops.addAll(extras);
                iterator.remove();
                continue;
            }
            if (stack.func_77973_b() == block.func_199767_j()) continue;
            extras = this.multiply(new ItemStack((IItemProvider)stack.func_77973_b(), stack.func_190916_E()), multiplier);
            extraDrops.addAll(extras);
            iterator.remove();
        }
        drops.addAll(extraDrops);
    }

    private List<ItemStack> multiply(ItemStack stack, int multiplier) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int count = stack.func_190916_E() * multiplier;
        while (count > 0) {
            int extract = Math.min(stack.func_77976_d(), count);
            count = -extract;
            list.add(new ItemStack((IItemProvider)stack.func_77973_b(), extract));
        }
        return list;
    }
}

